/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import superlord.goblinsanddungeons.entity.GarchEntity;
import superlord.goblinsanddungeons.entity.GobEntity;
import superlord.goblinsanddungeons.entity.GobberEntity;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.entity.GoblinSoulBulletEntity;
import superlord.goblinsanddungeons.entity.GobloEntity;
import superlord.goblinsanddungeons.entity.GoomEntity;
import superlord.goblinsanddungeons.entity.HobGobEntity;
import superlord.goblinsanddungeons.entity.event.GobKingTeleportEvent;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.EntityInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.ParticleInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GobKingEntity
extends GoblinEntity
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);

    public GobKingEntity(EntityType<? extends GobKingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean m_6785_(double p_27492_) {
        return false;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    protected SoundEvent m_7515_() {
        int laugh = this.f_19796_.nextInt(5);
        if (laugh == 0) {
            return SoundInit.GOBLIN_KING_LAUGH;
        }
        return SoundInit.GOBLIN_KING_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundInit.GOBLIN_KING_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.GOBLIN_KING_DEATH;
    }

    public void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.STAFF_AMETHYST.get()));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Raider.class, 5.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractVillager.class, 5.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 5.0f, 2.2, 2.2));
    }

    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public boolean onLivingFall(float distance, float damageMultiplier) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        int i = this.f_19796_.nextInt(999);
        if (this.m_5448_() != null && i == 0) {
            int goblin = this.f_19796_.nextInt(5);
            if (goblin == 0) {
                GobEntity gob = new GobEntity((EntityType<? extends GobEntity>)((EntityType)EntityInit.GOB.get()), this.f_19853_);
                gob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                gob.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(gob.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                this.f_19853_.m_7967_((Entity)gob);
            }
            if (goblin == 1) {
                GarchEntity garch = new GarchEntity((EntityType<? extends GarchEntity>)((EntityType)EntityInit.GARCH.get()), this.f_19853_);
                garch.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                garch.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(garch.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                this.f_19853_.m_7967_((Entity)garch);
            }
            if (goblin == 2) {
                GobloEntity goblo = new GobloEntity((EntityType<? extends GobloEntity>)((EntityType)EntityInit.GOBLO.get()), this.f_19853_);
                goblo.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                goblo.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(goblo.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                this.f_19853_.m_7967_((Entity)goblo);
            }
            if (goblin == 3) {
                GoomEntity goom = new GoomEntity((EntityType<? extends GoomEntity>)((EntityType)EntityInit.GOOM.get()), this.f_19853_);
                goom.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                goom.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(goom.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                this.f_19853_.m_7967_((Entity)goom);
            }
            if (goblin == 4) {
                HobGobEntity hobgob = new HobGobEntity((EntityType<? extends HobGobEntity>)((EntityType)EntityInit.HOBGOB.get()), this.f_19853_);
                hobgob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                hobgob.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(hobgob.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                this.f_19853_.m_7967_((Entity)hobgob);
            }
            if (goblin == 5) {
                GobberEntity gobber = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.f_19853_);
                GobberEntity gobber2 = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.f_19853_);
                GobberEntity gobber3 = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.f_19853_);
                GobberEntity gobber4 = new GobberEntity((EntityType<? extends GobberEntity>)((EntityType)EntityInit.GOBBER.get()), this.f_19853_);
                gobber.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                gobber2.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                gobber3.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                gobber4.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                gobber.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(gobber.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                gobber2.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(gobber2.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                gobber3.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(gobber3.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                gobber4.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(gobber4.m_142538_()), MobSpawnType.REINFORCEMENT, null, null);
                this.f_19853_.m_7967_((Entity)gobber);
                this.f_19853_.m_7967_((Entity)gobber2);
                this.f_19853_.m_7967_((Entity)gobber3);
                this.f_19853_.m_7967_((Entity)gobber4);
            }
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 35.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_6851_(difficultyIn);
        return spawnDataIn;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.nextFloat() < f * 0.3f) {
                entityIn.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ItemInit.GOB_SPAWN_EGG.get());
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        GoblinSoulBulletEntity soulBullet = new GoblinSoulBulletEntity(this.f_19853_, (LivingEntity)this);
        double d0 = target.m_20186_() - (double)1.1f;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - soulBullet.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        float f = (float)Math.sqrt(d1 * d1 + d3 * d3) * 0.2f;
        soulBullet.m_6686_(d1, d2 + (double)f, d3, 1.0f, 12.0f);
        this.f_19853_.m_5594_((Player)null, this.m_142538_(), SoundInit.SOUL_BULLET_LAUNCH, SoundSource.HOSTILE, 1.0f, 1.0f);
        this.m_5496_(SoundInit.SOUL_BULLET_LAUNCH, 1.0f, 1.0f);
        this.f_19853_.m_7967_((Entity)soulBullet);
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == CreatureAttributeInit.GOBLIN) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 16.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.nextInt(16) - 8);
            double d2 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 16.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            GobKingTeleportEvent event = new GobKingTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundInit.SPELL_CASTING, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundInit.SPELL_CASTING, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public boolean m_20984_(double x, double y, double z, boolean p_213373_7_) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        double d3 = y;
        boolean flag = false;
        Level world = this.f_19853_;
        BlockPos blockpos = new BlockPos(x, y, z);
        if (world.m_46805_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > 0) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = world.m_8055_(blockpos1);
                if (blockstate.m_60767_().m_76334_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.m_6021_(x, d3, z);
                if (world.m_45786_((Entity)this) && !world.m_46855_(this.m_142469_())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.m_6021_(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d4 = (double)j / 127.0;
            float f = (this.f_19796_.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.f_19796_.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.f_19796_.nextFloat() - 0.5f) * 0.2f;
            double d5 = Mth.m_14139_((double)d4, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_() * 2.0;
            double d6 = Mth.m_14139_((double)d4, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.nextDouble() * (double)this.m_20206_();
            double d7 = Mth.m_14139_((double)d4, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_() * 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleInit.GOB_SOUL_BULLET, d5, d6, d7, (double)f, (double)f1, (double)f2);
        }
        if (this instanceof PathfinderMob) {
            this.m_21573_().m_26573_();
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (source.m_7639_() instanceof LivingEntity && this.m_21223_() <= this.m_21233_() / 2.0f) {
            this.teleport();
        }
        return flag;
    }
}

